<?php
/**
 * @package     Joomla - > Site and Administrator payment info
 * @subpackage  com_Hikashop
 * @subpackage 	miladworkshop_paanaPardakht
 * @copyright   miladworkshop team => https://miladworkshop.ir
 * @copyright   Copyright (C) 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

if (!class_exists ('checkHack')){
	require_once JPATH_SITE . '/plugins/hikashoppayment/paanapardakht/paanapardakht_inputcheck.php';
}

class plgHikashoppaymentpaanaPardakht extends hikashopPaymentPlugin
{
	var $accepted_currencies = array( "IRR" ); 
	var $multiple = true; 
	var $name = 'paanapardakht';
	var $pluginConfig = array(
		'merchant_id' => array("شناسه مرچند",'input')
	);

	function __construct(&$subject, $config)
	{	
		return parent::__construct($subject, $config);
	}
	
	function onBeforeOrderCreate(&$order,&$do)
	{
		if(parent::onBeforeOrderCreate($order, $do) === true)
			return true;

		if (empty($this->payment_params->merchant_id))
		{
			$this->app->enqueueMessage('لطفا تنظیمات پلاگین paanaPardakht را وارد نمایید','error');
			$do = false;
		}
	}
	
	function onAfterOrderConfirm(&$order,&$methods,$method_id)
	{
		parent::onAfterOrderConfirm($order,$methods,$method_id); 

		$notify_url = HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=checkout&task=notify&notif_payment='.$this->name.'&tmpl=component&lang='.$this->locale . $this->url_itemid.'&orderid='.$order->order_id;
		$return_url = HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=checkout&task=after_end&order_id='.$order->order_id . $this->url_itemid;
		$cancel_url = HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=order&task=cancel_order&order_id='.$order->order_id . $this->url_itemid;

		$config 		= JFactory::getConfig();
		$app			= JFactory::getApplication();
		$Amount 		= ($order->cart->full_total->prices[0]->price_value_with_tax)/10; // Toman 
		$Description 	= 'خرید محصول از فروشگاه   '. $config->get( 'sitename' ); 
		$Email 			= ''; 
		$Mobile 		= ''; 
		$CallbackURL 	=  $notify_url;
			
		try {
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, 'https://paanapardakht.com/webservice/rest/PaymentRequest');
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
			curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$this->payment_params->merchant_id}&Amount={$Amount}&InvoiceID={$order->order_id}&Description={$Description}&Email={$Email}&Mobile={$Mobile}&CallbackURL=". urlencode($CallbackURL));
			curl_setopt($curl, CURLOPT_TIMEOUT, 30);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			$curl_exec = curl_exec($curl);
			curl_close($curl);

			$result = json_decode($curl_exec);

			if (isset($result->Status) && $result->Status == 100)
			{
				$vars['paanapardakht'] = $result->PaymentUrl;
				$this->vars = $vars;

				return $this->showPage('end'); 	
			} else {
				$result_error 	= (isset($result->Status) && $result->Status != "") ? $result->Status : "error";				
				$msg 			= $this->getGateMsg($result_error); 
				$app			= JFactory::getApplication();
				$link 			= $cancel_url;

				$app->redirect($link, '<h2>'.$msg.'</h2>', $msgType='Error'); 
			}
		}
		catch(\SoapFault $e) {
			$msg= $this->getGateMsg('error'); 
			$app	= JFactory::getApplication();
			$link = $cancel_url;
			$app->redirect($link, '<h2>'.$msg.'</h2>', $msgType='Error'); 
		}
	}

	function onPaymentNotification(&$statuses)
	{
		$app		= JFactory::getApplication();		
		$jinput 	= $app->input;
		$orderId 	= $jinput->get->get('orderid', '0', 'INT');

		if($orderId != null)
		{
			$Order = $this->getOrder($orderId);
			$this->loadPaymentParams($Order);
			$return_url 		= HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=checkout&task=after_end&order_id='.$orderId.$this->url_itemid;
			$cancel_url 		= HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=order&task=cancel_order&order_id='.$orderId.$this->url_itemid;
			$history 			= new stdClass();
			$history->amount 	= round($Order->order_full_price,5)/10;
			
			$Authority 			= $jinput->post->get('Authority', '', 'STRING');
			$status 			= $jinput->post->get('PaymentStatus', '', 'STRING');			

			if (checkHack::checkString($status))
			{
				if ($status == 'OK')
				{ 
					try {
						$curl = curl_init();
						curl_setopt($curl, CURLOPT_URL, 'https://paanapardakht.com/webservice/rest/PaymentVerification');
						curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
						curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$this->payment_params->merchant_id}&Amount={$history->amount}&Authority={$Authority}");
						curl_setopt($curl, CURLOPT_TIMEOUT, 30);
						curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
						curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
						$curl_exec = curl_exec($curl);
						curl_close($curl);

						$result 		= json_decode($curl_exec);
						$resultStatus 	= abs($result->Status); 

						if (isset($result->Status) && $result->Status == 100)
						{							
							$msg= $this->getGateMsg($resultStatus); 
							$history->notified = 1;
							$history->data = 'شماره پیگیری '. $result->RefID;
							$this->modifyOrder($orderId, 'confirmed', $history, true); 
							$app->redirect($return_url, '<h2>'.$msg.'</h2>'.'<h3>'. $result->RefID .'شماره پیگری ' .'</h3>' , $msgType='Message'); 
							
						} else {						
							$msg= $this->getGateMsg($resultStatus); 
							$this->modifyOrder($orderId, 'cancelled', false, false);
							$app->redirect($cancel_url, '<h2>'.$msg.'</h2>' , $msgType='Error'); 	
						}
					}
					catch(\SoapFault $e) {
						$msg= $this->getGateMsg('error'); 
						$this->modifyOrder($orderId, 'cancelled', false, false); 
						$app->redirect($cancel_url, '<h2>'.$msg.'</h2>' , $msgType='Error'); 
					}
				}
				else {
					$msg= $this->getGateMsg(intval(103)); 
					$this->modifyOrder($orderId, 'cancelled', false, false); 
					$app->redirect($cancel_url, '<h2>'.$msg.'</h2>' , $msgType='Error'); 	
				}
			}
			else {
				$msg = $this->getGateMsg('hck2'); 
				$this->modifyOrder($orderId, 'cancelled', false, false); 
				$app->redirect($cancel_url, '<h2>'.$msg.'</h2>' , $msgType='Error'); 
			}
		}
		else {
			$msg= $this->getGateMsg('notff'); 
			$this->modifyOrder($orderId, 'cancelled', false, false); 
			$app->redirect($cancel_url, '<h2>'.$msg.'</h2>' , $msgType='Error'); 
		}
	}

	public function getGateMsg($msgId)
	{
		switch($msgId)
		{
			case	'-1': $out = 'درخواست باید از طریق متد ارسال شود'; break;
			case	'-2': $out = 'مقداری برای MerchantID ارسال نشده است'; break;
			case	'-3': $out = 'مقداری برای Amount ارسال نشده است'; break;
			case	'-4': $out = 'مقداری برای CallbackURL ارسال نشده است'; break;
			case	'-5': $out = 'حداقل مبلغ قابل پرداخت 100 تومان می‌باشد'; break;
			case	'-6': $out = 'MerchantID وارد شده در سیستم یافت نشد'; break;
			case	'-7': $out = 'MerchantID وارد شده فعال نیست'; break;
			case	'-8': $out = 'اکانت شما تجاری نیست, لذا امکان استفاده از وبسرویس را ندارید'; break;
			case	'-9': $out = 'IP معتبر نیست'; break;
			case	'-10': $out = 'آدرس بازگشتی با آدرس درگاه پرداخت ثبت شده همخوانی ندارد'; break;
			case	'-11': $out = 'خطای در وب سرویس - ایجاد تراکنش با خطا مواجه شد'; break;
			case	'-12': $out = 'مقدار Authority ارسالی معتبر نیست - تراکنش یافت نشد'; break;
			case	'-13': $out = 'مقداری برای Authority ارسال نشده است'; break;
			case	'-14': $out = 'اطلاعات تراکنش یافت نشد, مقدار Authority را بررسی کرده و صحیح بودن آن اطمانان حاصل کنید'; break;
			case	'-15': $out = 'تراکنش پرداخت نشده است'; break;
			case	'-16': $out = 'مبلغ ارسال شده با مبلغ تراکنش یکسان نیست, مقدار Amount را بررسی کرده و نسبت به صحت آن اطمینان حاصل کنید'; break;
			case	'-17': $out = 'دسترسی شما به این تراکنش رد شد, Authority این تراکنش برای MerchantID شما ثبت نشده است'; break;
			case	'-18': $out = 'پرداخت تراکنش با موفقیت انجام شده است, اما در بروزرسانی کیف پول پذیرنده مشکلی پیش آمده است'; break;
			case	'-19': $out = 'وضعیت تراکنش نامشخص است'; break;
			case	100: $out = 'پرداخت با موفقیت انجام شد';break;
			case	101: $out = 'عمليات پرداخت موفق بوده و قبلا PaymentVerification تراكنش انجام شده است';break;
			case	103: $out = 'کاربر از انجام تراکنش منصرف شده است';break;
			case	'1':
			case	'error': $out ='خطا غیر منتظره رخ داده است';break;
			case	'hck2': $out = 'لطفا از کاراکترهای مجاز استفاده کنید';break;
			case	'notff': $out = 'سفارش پیدا نشد';break;
			default: $out ='خطا غیر منتظره رخ داده است';break;
		}

		return $out;
	}

	public function getInfo ($id){
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('address_telephone');
		$query->from($db->qn('#__hikashop_address'));
		$query->where($db->qn('address_user_id') .  '=' . $db->q(intval($id)));
		$db->setQuery((string)$query); 
		$result = $db->Loadresult();
		return $result;
	}
}
