<?php
/**
 * @package     Joomla - > Site and Administrator payment info
 * @subpackage  com_virtuemart
 * @subpackage 	Miladworkshop_paanaPardakht
 * @copyright   miladworkshop team => https://miladworkshop.ir
 * @copyright   Copyright (C) 2020 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined ('_JEXEC') or die('Restricted access');

if (!class_exists ('vmPSPlugin')) {
	require(JPATH_VM_PLUGINS . '/vmpsplugin.php');
}

if (!class_exists ('checkHack')) {
	require_once( VMPATH_ROOT . '/plugins/vmpayment/paanapardakht/helper/inputcheck.php');
}


class plgVmPaymentpaanaPardakht extends vmPSPlugin {

	function __construct (& $subject, $config) {

		parent::__construct ($subject, $config);
		$this->_loggable = TRUE;
		$this->tableFields = array_keys ($this->getTableSQLFields ());
		$this->_tablepkey = 'id';
		$this->_tableId = 'id';
		$varsToPush = array('merchant_id' => array('', 'varchar'));
		$this->setConfigParameterable($this->_configTableFieldName, $varsToPush);
	}

	public function getVmPluginCreateTableSQL () {
		return $this->createTableSQL ('Payment paanaPardakht Table');
	}

	function getTableSQLFields () {

		$SQLfields = array(
			'id'                          => 'int(1) UNSIGNED NOT NULL AUTO_INCREMENT',
			'virtuemart_order_id'         => 'int(1) UNSIGNED',
			'order_number'                => 'char(64)',
			'order_pass'                  => 'varchar(50)',
			'virtuemart_paymentmethod_id' => 'mediumint(1) UNSIGNED',
			'crypt_virtuemart_pid' 	      => 'varchar(255)',
			'salt'                        => 'varchar(255)',
			'payment_name'                => 'varchar(5000)',
			'amount'                      => 'decimal(15,5) NOT NULL DEFAULT \'0.00000\'',
			'payment_currency'            => 'char(3)',
			'email_currency'              => 'char(3)',
			'mobile'                      => 'varchar(12)',
			'tracking_code'               => 'varchar(50)'
		);

		return $SQLfields;
	}


	function plgVmConfirmedOrder ($cart, $order)
	{
		if (!$this->selectedThisByMethodId($cart->virtuemart_paymentmethod_id)) {
			return null; 
		}
		
		if (!($method = $this->getVmPluginMethod ($order['details']['BT']->virtuemart_paymentmethod_id))) {
			return NULL; 
		}

		$app	= JFactory::getApplication();
		$session = JFactory::getSession();
		$salt = JUserHelper::genRandomPassword(32);
		$crypt_virtuemartPID = JUserHelper::getCryptedPassword($order['details']['BT']->virtuemart_order_id, $salt);
		if ($session->isActive('uniq')) {
			$session->clear('uniq');
		}
		$session->set('uniq', $crypt_virtuemartPID);

		$payment_currency = $this->getPaymentCurrency($method,$order['details']['BT']->payment_currency_id);
		$totalInPaymentCurrency = vmPSPlugin::getAmountInCurrency($order['details']['BT']->order_total,$payment_currency);
		$currency_code_3 = shopFunctions::getCurrencyByID($payment_currency, 'currency_code_3');
		$email_currency = $this->getEmailCurrency($method);
		$dbValues['payment_name'] = $this->renderPluginName ($method) . '<br />';
		$dbValues['order_number'] = $order['details']['BT']->order_number;
		$dbValues['order_pass'] = $order['details']['BT']->order_pass;
		$dbValues['virtuemart_paymentmethod_id'] = $order['details']['BT']->virtuemart_paymentmethod_id;
		$dbValues['crypt_virtuemart_pid'] = $crypt_virtuemartPID;
		$dbValues['salt'] = $salt;
		$dbValues['payment_currency'] = $order['details']['BT']->order_currency;
		$dbValues['email_currency'] = $email_currency;
		$dbValues['amount'] = $totalInPaymentCurrency['value'];
		$dbValues['mobile'] = $order['details']['BT']->phone_2;
		$this->storePSPluginInternalData ($dbValues);
		$id = JUserHelper::getCryptedPassword($order['details']['BT']->virtuemart_order_id);
		$app	= JFactory::getApplication();
		$Amount = $totalInPaymentCurrency['value']/10; // Toman 
		$Description = 'خرید محصول از فروشگاه   '. $cart->vendor->vendor_store_name; 
		$MerchantID = $method->merchant_id;
		$CallbackURL = JURI::root().'index.php?option=com_virtuemart&view=pluginresponse&task=pluginresponsereceived&gid=3'; 
		
		try {
			$Email 		= "";
			$Mobile 	= "";

			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, 'https://paanapardakht.com/webservice/rest/PaymentRequest');
			curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
			curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$MerchantID}&Amount={$Amount}&InvoiceID={$id}&Description={$Description}&Email={$Email}&Mobile={$Mobile}&CallbackURL=". urlencode($CallbackURL));
			curl_setopt($curl, CURLOPT_TIMEOUT, 30);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			$curl_exec = curl_exec($curl);
			curl_close($curl);

			$result 		= json_decode($curl_exec);
			$resultStatus 	= abs($result->Status); 

			if ($resultStatus == 100)
			{
				header("Location: {$result->PaymentUrl}"); 
			} else {
				$result_error 	= (isset($result->Status) && $result->Status != "") ? $result->Status : "error";	
				$msg 			= $this->getGateMsg($result_error); 
				$link 			= JRoute::_(JUri::root().'index.php/component/virtuemart/cart',false);
				$app->redirect($link, '<h2>'.$msg.'</h2>', $msgType='Error'); 
			}
		}
		catch(\SoapFault $e) {
			$msg= $this->getGateMsg('error'); 
			$link = JRoute::_(JUri::root().'index.php/component/virtuemart/cart',false);
			$app->redirect($link, '<h2>'.$msg.'</h2>', $msgType='Error'); 
		}
		
	}

	public function plgVmOnPaymentResponseReceived(&$html)
	{	
		if (!class_exists('VirtueMartModelOrders')) {
			require(VMPATH_ADMIN . DS . 'models' . DS . 'orders.php');
		}

		$app		= JFactory::getApplication();		
		$jinput 	= $app->input;
		$gateway 	= $jinput->get->get('gid', '0', 'INT');
		
		if ($gateway == '3')
		{
			$Authority 	= $jinput->post->get('Authority', '', 'STRING');
			$status 	= $jinput->post->get('PaymentStatus', '', 'STRING');
			
			$session = JFactory::getSession();

			if ($session->isActive('uniq') && $session->get('uniq') != null) {
				$cryptID = $session->get('uniq'); 
			} else {
				$msg = $this->getGateMsg('notff'); 
				$link = JRoute::_(JUri::root().'index.php/component/virtuemart/cart',false);
				$app->redirect($link, '<h2>'.$msg.'</h2>', $msgType='Error'); 
			}
			$orderInfo = $this->getOrderInfo ($cryptID);
			if ($orderInfo != null){
				if (!($currentMethod = $this->getVmPluginMethod($orderInfo->virtuemart_paymentmethod_id))) {
					return NULL; 
				}			
			}
			else {
				return NULL;  
			}

			$salt 	= $orderInfo->salt;
			$id 	= $orderInfo->virtuemart_order_id;
			$uId 	= $cryptID.':'.$salt;
			
			$order_id 	= $orderInfo->order_number; 
			//$mobile 	= $orderInfo->mobile; 
			$payment_id = $orderInfo->virtuemart_paymentmethod_id; 
			$pass_id 	= $orderInfo->order_pass;
			$price 		= round($orderInfo->amount,5);
			$method 	= $this->getVmPluginMethod ($payment_id);
			
			if (checkHack::checkString($status) != true)
			{
				$msg 	= $this->getGateMsg('hck2'); 
				$link 	= JRoute::_(JUri::root().'index.php/component/virtuemart/cart',false);
				$app->redirect($link, '<h2>'.$msg.'</h2>'.$virtuemart_order_id, $msgType='Error'); 
			}
			
			if (JUserHelper::verifyPassword($id , $uId))
			{
				if ($status == 'OK')
				{
					try {
						$Amount_price = $price/10;

						$curl = curl_init();
						curl_setopt($curl, CURLOPT_URL, 'https://paanapardakht.com/webservice/rest/PaymentVerification');
						curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
						curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$method->merchant_id}&Amount={$Amount_price}&Authority={$Authority}");
						curl_setopt($curl, CURLOPT_TIMEOUT, 30);
						curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
						curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
						$curl_exec = curl_exec($curl);
						curl_close($curl);

						$result = json_decode($curl_exec);
						$resultStatus = abs($result->Status); 

						if ($resultStatus == 100)
						{
							$msg 	= $this->getGateMsg($resultStatus);
							$html 	= $this->renderByLayout('paanapardakht_payment', array(
								'order_number' =>$order_id,
								'order_pass' =>$pass_id,
								'tracking_code' => $result->RefID,
								'status' => $msg
							));
							$this->updateStatus ('C',1,$msg,$id);
							$this->updateOrderInfo ($id,$result->RefID);
							vRequest::setVar ('html', $html);
							$cart = VirtueMartCart::getCart();
							$cart->emptyCart();
							$session->clear('uniq'); 
						} 
						else {
							$msg= $this->getGateMsg($resultStatus);
							$link = JRoute::_(JUri::root().'index.php/component/virtuemart/cart',false);
							$app->redirect($link, '<h2>'.$msg.'</h2>', $msgType='Error'); 
						}
					}
					catch(\SoapFault $e) {
						$msg= $this->getGateMsg('error'); 
						$link = JRoute::_(JUri::root().'index.php/component/virtuemart/cart',false);
						$app->redirect($link, '<h2>'.$msg.'</h2>', $msgType='Error'); 
					}
				}
				else {
					$msg= $this->getGateMsg(intval(103)); 
					$this->updateStatus ('X',0,$msg,$id); 
					$link = JRoute::_(JUri::root().'index.php/component/virtuemart/cart',false);
					$app->redirect($link, '<h2>'.$msg.'</h2>', $msgType='Error'); 
				}
			}
			else {	
				$msg= $this->getGateMsg('notff');
				$link = JRoute::_(JUri::root().'index.php/component/virtuemart/cart',false);
				$app->redirect($link, '<h2>'.$msg.'</h2>', $msgType='Error'); 
			}
		}
		else {
			return NULL;
		}
	}


	protected function getOrderInfo ($id){
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')
			->from($db->qn('#__virtuemart_payment_plg_paanapardakht'));
		$query->where($db->qn('crypt_virtuemart_pid') . ' = ' . $db->q($id));
		$db->setQuery((string)$query); 
		$result = $db->loadObject();
		return $result;
	}

	protected function updateOrderInfo ($id,$trackingCode){
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$fields = array($db->qn('tracking_code') . ' = ' . $db->q($trackingCode));
		$conditions = array($db->qn('virtuemart_order_id') . ' = ' . $db->q($id));
		$query->update($db->qn('#__virtuemart_payment_plg_paanapardakht'));
		$query->set($fields);
		$query->where($conditions);
		
		$db->setQuery($query);
		$result = $db->execute();
	}

	
	protected function checkConditions ($cart, $method, $cart_prices) {
		$amount = $this->getCartAmount($cart_prices);
		$address = (($cart->ST == 0) ? $cart->BT : $cart->ST);

		if($this->_toConvert){
			$this->convertToVendorCurrency($method);
		}
		
		$countries = array();
		if (!empty($method->countries)) {
			if (!is_array ($method->countries)) {
				$countries[0] = $method->countries;
			} else {
				$countries = $method->countries;
			}
		}

		if (!is_array ($address)) {
			$address = array();
			$address['virtuemart_country_id'] = 0;
		}

		if (!isset($address['virtuemart_country_id'])) {
			$address['virtuemart_country_id'] = 0;
		}
		if (count ($countries) == 0 || in_array ($address['virtuemart_country_id'], $countries) ) {
			return TRUE;
		}

		return FALSE;
	}
	
	public function plgVmDisplayListFEPayment(VirtueMartCart $cart, $selected = 0, &$htmlIn) {

		if ($this->getPluginMethods($cart->vendorId) === 0) {
			if (empty($this->_name)) {
				$app = JFactory::getApplication();
				$app->enqueueMessage(vmText::_('COM_VIRTUEMART_CART_NO_' . strtoupper($this->_psType)));
				return false;
			} else {
				return false;
			}
		}
		$method_name = $this->_psType . '_name';

		$htmla = array();
		foreach ($this->methods as $this->_currentMethod) {
			if ($this->checkConditions($cart, $this->_currentMethod, $cart->cartPrices)) {

				$html = '';
				$cartPrices=$cart->cartPrices;
				if (isset($this->_currentMethod->cost_method)) {
					$cost_method=$this->_currentMethod->cost_method;
				} else {
					$cost_method=true;
				}
				$methodSalesPrice = $this->setCartPrices($cart, $cartPrices, $this->_currentMethod, $cost_method);

				$this->_currentMethod->payment_currency = $this->getPaymentCurrency($this->_currentMethod);
				$this->_currentMethod->$method_name = $this->renderPluginName($this->_currentMethod);
				$html .= $this->getPluginHtml($this->_currentMethod, $selected, $methodSalesPrice);
				$htmla[] = $html;
			}
		}
		$htmlIn[] = $htmla;
		return true;

	}
	
	public function plgVmOnSelectCheckPayment (VirtueMartCart $cart, &$msg) {
		if (!$this->selectedThisByMethodId($cart->virtuemart_paymentmethod_id)) {
			return null; 
		}
		
		return $this->OnSelectCheck ($cart);
	}
 
	function plgVmOnCheckAutomaticSelectedPayment (VirtueMartCart $cart, array $cart_prices = array(), &$paymentCounter) { 
		return $this->onCheckAutomaticSelected ($cart, $cart_prices, $paymentCounter);
	}

	public function plgVmonSelectedCalculatePricePayment (VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name) { 
		return $this->onSelectedCalculatePrice ($cart, $cart_prices, $cart_prices_name);
	}

	public function plgVmOnCheckoutCheckDataPayment(  VirtueMartCart $cart) { 
		if (!$this->selectedThisByMethodId($cart->virtuemart_paymentmethod_id)) {
			return NULL; 
		}
			return true;
	}

	function plgVmOnStoreInstallPaymentPluginTable ($jplugin_id) {

		return $this->onStoreInstallPluginTable ($jplugin_id);
	}
	 
	
	function plgVmonShowOrderPrintPayment ($order_number, $method_id) {
		return $this->onShowOrderPrint ($order_number, $method_id);
	}

	function plgVmDeclarePluginParamsPaymentVM3( &$data) {
		return $this->declarePluginParams('payment', $data);
	}
	function plgVmSetOnTablePluginParamsPayment ($name, $id, &$table) {

		return $this->setOnTablePluginParams ($name, $id, $table);
	}

	static function getPaymentCurrency (&$method, $selectedUserCurrency = false) {

		if (empty($method->payment_currency)) {
			$vendor_model = VmModel::getModel('vendor');
			$vendor = $vendor_model->getVendor($method->virtuemart_vendor_id);
			$method->payment_currency = $vendor->vendor_currency;
			return $method->payment_currency;
		} else {

			$vendor_model = VmModel::getModel( 'vendor' );
			$vendor_currencies = $vendor_model->getVendorAndAcceptedCurrencies( $method->virtuemart_vendor_id );

			if(!$selectedUserCurrency) {
				if($method->payment_currency == -1) {
					$mainframe = JFactory::getApplication();
					$selectedUserCurrency = $mainframe->getUserStateFromRequest( "virtuemart_currency_id", 'virtuemart_currency_id', vRequest::getInt( 'virtuemart_currency_id', $vendor_currencies['vendor_currency'] ) );
				} else {
					$selectedUserCurrency = $method->payment_currency;
				}
			}

			$vendor_currencies['all_currencies'] = explode(',', $vendor_currencies['all_currencies']);
			if(in_array($selectedUserCurrency,$vendor_currencies['all_currencies'])){
				$method->payment_currency = $selectedUserCurrency;
			} else {
				$method->payment_currency = $vendor_currencies['vendor_currency'];
			}

			return $method->payment_currency;
		}

	}

	public function getGateMsg ($msgId) {
		switch($msgId)
		{
			case	'-1': $out = 'درخواست باید از طریق متد ارسال شود'; break;
			case	'-2': $out = 'مقداری برای MerchantID ارسال نشده است'; break;
			case	'-3': $out = 'مقداری برای Amount ارسال نشده است'; break;
			case	'-4': $out = 'مقداری برای CallbackURL ارسال نشده است'; break;
			case	'-5': $out = 'حداقل مبلغ قابل پرداخت 100 تومان می‌باشد'; break;
			case	'-6': $out = 'MerchantID وارد شده در سیستم یافت نشد'; break;
			case	'-7': $out = 'MerchantID وارد شده فعال نیست'; break;
			case	'-8': $out = 'اکانت شما تجاری نیست, لذا امکان استفاده از وبسرویس را ندارید'; break;
			case	'-9': $out = 'IP معتبر نیست'; break;
			case	'-10': $out = 'آدرس بازگشتی با آدرس درگاه پرداخت ثبت شده همخوانی ندارد'; break;
			case	'-11': $out = 'خطای در وب سرویس - ایجاد تراکنش با خطا مواجه شد'; break;
			case	'-12': $out = 'مقدار Authority ارسالی معتبر نیست - تراکنش یافت نشد'; break;
			case	'-13': $out = 'مقداری برای Authority ارسال نشده است'; break;
			case	'-14': $out = 'اطلاعات تراکنش یافت نشد, مقدار Authority را بررسی کرده و صحیح بودن آن اطمانان حاصل کنید'; break;
			case	'-15': $out = 'تراکنش پرداخت نشده است'; break;
			case	'-16': $out = 'مبلغ ارسال شده با مبلغ تراکنش یکسان نیست, مقدار Amount را بررسی کرده و نسبت به صحت آن اطمینان حاصل کنید'; break;
			case	'-17': $out = 'دسترسی شما به این تراکنش رد شد, Authority این تراکنش برای MerchantID شما ثبت نشده است'; break;
			case	'-18': $out = 'پرداخت تراکنش با موفقیت انجام شده است, اما در بروزرسانی کیف پول پذیرنده مشکلی پیش آمده است'; break;
			case	'-19': $out = 'وضعیت تراکنش نامشخص است'; break;
			case	100: $out = 'پرداخت با موفقیت انجام شد';break;
			case	101: $out = 'عمليات پرداخت موفق بوده و قبلا PaymentVerification تراكنش انجام شده است';break;
			case	103: $out = 'کاربر از انجام تراکنش منصرف شده است';break;
			case	'1':
			case	'error': $out ='خطا غیر منتظره رخ داده است';break;
			case	'hck2': $out = 'لطفا از کاراکترهای مجاز استفاده کنید';break;
			case	'notff': $out = 'سفارش پیدا نشد';break;
			default: $out ='خطا غیر منتظره رخ داده است';break;
		}

		return $out;
	}

	protected function updateStatus ($status,$notified,$comments='',$id) {
		$modelOrder = VmModel::getModel ('orders');	
		$order['order_status'] = $status;
		$order['customer_notified'] = $notified;
		$order['comments'] = $comments;
		$modelOrder->updateStatusForOneOrder ($id, $order, TRUE);
	}

}
