<?php
/**d
 * @package    paanapardakht payment module
 * @author     Milad Maldar
 * @copyright  2020  miladworkshop.ir
 * @version    1.00
 */
if (!defined('_PS_VERSION_'))
	exit ;

class paanapardakht extends PaymentModule
{
	private $_html 			= '';
	private $_postErrors 	= array();

	public function __construct()
	{

		$this->name 			= 'paanapardakht';
		$this->tab 				= 'payments_gateways';
		$this->version 			= '1.0';
		$this->author 			= 'Milad Maldar';
		$this->currencies 		= true;
		$this->currencies_mode 	= 'radio';

		parent::__construct();

		$this->displayName 		= $this->l('paanapardakht Payment Modlue');
		$this->description 		= $this->l('Online Payment With paanapardakht');
		$this->confirmUninstall = $this->l('Are you sure you want to delete your details?');

		if (!sizeof(Currency::checkPaymentCurrencies($this->id)))
			$this->warning = $this->l('No currency has been set for this module');
		$config = Configuration::getMultiple(array('paanapardakht_API'));
		if (!isset($config['paanapardakht_API']))
			$this->warning = $this->l('You have to enter your paanapardakht merchant key to use paanapardakht for your online payments.');
	}

	public function install()
	{
		if (!parent::install() || !Configuration::updateValue('paanapardakht_API', '') || !Configuration::updateValue('paanapardakht_LOGO', '') || !Configuration::updateValue('paanapardakht_HASH_KEY', $this->hash_key()) || !$this->registerHook('payment') || !$this->registerHook('paymentReturn'))
			return false;
		else
			return true;
	}

	public function uninstall()
	{
		if (!Configuration::deleteByName('paanapardakht_API') || !Configuration::deleteByName('paanapardakht_LOGO') || !Configuration::deleteByName('paanapardakht_HASH_KEY') || !parent::uninstall())
			return false;
		else
			return true;
	}

	public function hash_key()
	{
		$en 	= array('a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z');
		$one 	= rand(1, 26);
		$two 	= rand(1, 26);
		$three 	= rand(1, 26);

		return $hash = $en[$one] . rand(0, 9) . rand(0, 9) . $en[$two] . $en[$tree] . rand(0, 9) . rand(10, 99);
	}

	public function getContent()
	{

		if (Tools::isSubmit('paanapardakht_setting'))
		{
			Configuration::updateValue('paanapardakht_API', $_POST['pn_API']);
			Configuration::updateValue('paanapardakht_LOGO', $_POST['pn_LOGO']);
			$this->_html .= '<div class="conf confirm">' . $this->l('تنظیمات با موفقیت ثبت و ذخیره شد') . '</div>';
		}

		$this->_generateForm();

		return $this->_html;
	}

	private function _generateForm()
	{
		$this->_html .= '<div align="center"><form action="' . $_SERVER['REQUEST_URI'] . '" method="post">';
		$this->_html .= $this->l('کد درگاه ( Merchant )') . '<br/><br/>';
		$this->_html .= '<input type="text" name="pn_API" value="' . Configuration::get('paanapardakht_API') . '" ><br/><br/>';
		$this->_html .= '<input type="submit" name="paanapardakht_setting"';
		$this->_html .= 'value="' . $this->l('ثبت و ذخیره سازی تنظیمات') . '" class="button" />';
		$this->_html .= '</form><br/></div>';
	}

	public function do_payment($cart)
	{
		$MerchantID 	= Configuration::get('paanapardakht_API');
		$amount 		= floatval(number_format($cart ->getOrderTotal(true, 3), 2, '.', ''));
		$orderId 		= $cart ->id;
		$txt 			= 'پرداخت سفارش شماره: ' . $cart ->id;
		$Email 			= '';
		$Mobile 		= '';
		$callbackUrl 	= (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . __PS_BASE_URI__ . 'modules/paanapardakht/cb_paanapardakht.php?do=call_back&id=' . $cart ->id . '&amount=' . $amount;

		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, 'https://paanapardakht.com/webservice/rest/PaymentRequest');
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
		curl_setopt($curl, CURLOPT_POSTFIELDS, "MerchantID={$MerchantID}&Amount={$amount}&InvoiceID={$orderId}&Description={$txt}&Email={$Email}&Mobile={$Mobile}&CallbackURL=". urlencode($callbackUrl));
		curl_setopt($curl, CURLOPT_TIMEOUT, 30);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		$curl_exec = curl_exec($curl);
		curl_close($curl);

		$result = json_decode($curl_exec);

		$hash 							= Configuration::get('paanapardakht_HASH');
		$_SESSION['order' . $orderId] 	= md5($orderId . $amount . $hash);

		if (isset($result->Status) && $result->Status == 100)
		{
			echo $this->success($this->l('Redirecting...'));
			echo '<script>window.location=("'. $result->PaymentUrl .'");</script>';
		} else {
			$result_status = (isset($result->Status) && $result->Status != "") ? $result->Status : "Error connecting to web service";

			echo $this->error($this->l('There is a problem.') . ' (' . $result_status . ')');
		}
	}

	public function error($str)
	{
		return '<div class="alert error">' . $str . '</div>';
	}

	public function success($str)
	{
		echo '<div class="conf confirm">' . $str . '</div>';
	}

	public function hookPayment($params)
	{
		global $smarty;

		$smarty ->assign('paanapardakht_logo', Configuration::get('paanapardakht_LOGO'));

		if ($this->active)
			return $this->display(__FILE__, 'paanapardakhtpayment.tpl');
	}

	public function hookPaymentReturn($params)
	{
		if ($this->active)
			return $this->display(__FILE__, 'zpconfirmation.tpl');
	}

}
// End of: paanapardakht.php
?>